/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.svnaccess;

/**
 * Encapsulates information of a dir item
 * during a SVN LIST command including
 * <ul>
 * <li><b>path<b>:     		path relative to the issued list/info command
 * <li><b>crRelPath<b>:     path relative to the component repository root path
 * <li><b>revision</b>: 	path's revision
 * <li><b>node-kind</b>:	path's node-kind - see {@link NodeKind}
 * </ul>
 */
public class SvnDirEntry {

	private final String path;
	private final String crRelPath;
	private final long revision;
	private final NodeKind nodeKind;
	
	public SvnDirEntry(String path, String crRelPath, long revision, NodeKind nodeKind) {
		this.path = path;
		this.crRelPath = crRelPath;
		this.revision = revision;
		this.nodeKind = nodeKind;
	}

    /**
     * @return
     *  path relative to the svn list url
     */
    public String getPath() {
		return path;
	}

    /**
     * @return
     *  path relative to the cr-base URL
     */
	public String getCrRelPath() {
		return crRelPath;
	}

    /**
     * @return
     *  last changed revision
     */
	public long getRevision() {
		return revision;
	}

    /**
     * @return
     *  dir entry kind (file or dir or ...)
     */
    public NodeKind getNodeKind() { return nodeKind; }

	@Override
	public String toString() {
		return "SvnDirEntry [path=" + path + ", crRelPath=" + crRelPath
				+ ", revision=" + revision + ", nodeKind=" + nodeKind + "]";
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((crRelPath == null) ? 0 : crRelPath.hashCode());
		result = prime * result
				+ ((nodeKind == null) ? 0 : nodeKind.hashCode());
		result = prime * result + ((path == null) ? 0 : path.hashCode());
		result = prime * result + (int) (revision ^ (revision >>> 32));
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SvnDirEntry other = (SvnDirEntry) obj;
		if (crRelPath == null) {
			if (other.crRelPath != null)
				return false;
		} else if (!crRelPath.equals(other.crRelPath))
			return false;
		if (nodeKind != other.nodeKind)
			return false;
		if (path == null) {
			if (other.path != null)
				return false;
		} else if (!path.equals(other.path))
			return false;
		if (revision != other.revision)
			return false;
		return true;
	}

}
