/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.svnaccess;

/**
 * Encapsulates information of a log item 
 * during a SVN LOG command including
 * <ul>
 * <li><b>svnPath<b>:     	the path is relative to the SVN root
 * <li><b>revision</b>: 	path's revision
 * <li><b>node-kind</b>:	path's node-kind - see {@link NodeKind}
 * <li><b>action</b>:		the operation on the path at the given revision
 * </ul> 
 */
public class SvnLogItem {

	public enum Action {added, modified, deleted, replaced;

        /*
         * I.e. 'A'dd, 'D'elete, 'R'eplace, 'M'odify
         */
        public static Action fromChar(char action) {
            switch (Character.toUpperCase(action)) {
                case 'A': return added;
                case 'D': return deleted;
                case 'M': return modified;
                case 'R': return replaced;
                default:  throw new IllegalArgumentException("Unsupported Action '" + action + "'!");
            }
        }
    }

	// 	path relative to SVN root URL
	private final String path;
	
	// current revision of the item
	private final long revision;
	
	// one of added, modified, deleted, replaced
	private final Action action;
	
	public SvnLogItem(String path, long revision, Action action) {
		this.path = path;
		this.revision = revision;
		this.action = action;
	}

	public String getPath() {
		return path;
	}

	public long getRevision() {
		return revision;
	}

	public Action getAction() {
		return action;
	}

	@Override
	public String toString() {
		return "SvnLogItem [path=" + path + ", revision=" + revision
				+ ", action=" + action + "]";
	}
}
