/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.eclipsoid.z2info;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONObject;

public class VersionRetriever extends AbstractRetriever {

	private static final String SERVER_VERSION = "2.1.0";
	private static final String VERSION_KEY = "serverVersion";

	public String getJsonKey() {
		return VERSION_KEY;
	}
	
	public boolean isProviderFor(String type) {
		return true;
	}

	public boolean supportsVersion(String clientVersion) {
		return true;
	}
	
	public void provideInfoInto(JSONObject result) throws IOException {
		result.put(VERSION_KEY, SERVER_VERSION);
	}

	public static String getClientVersion(HttpServletRequest req) {
		String result = req.getParameter("v");
		if (result == null || result.length() == 0) {
			result = "1.0.0";
		}
		return result;
	}
		
	public static void main(String[] args) {
		System.out.println("1.0.0".compareTo("2.0.0"));
		System.out.println("1.2.0".compareTo("1.2.1"));
		System.out.println("1.2.1".compareTo("1.20.1"));
	}
}
