/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.log4j;

import java.io.File;

import org.apache.log4j.PropertyConfigurator;

import com.zfabrik.components.IComponentsManager;
import com.zfabrik.components.IDependencyComponent;
import com.zfabrik.resources.ResourceBusyException;
import com.zfabrik.resources.provider.Resource;

/**
 * log 4j configuration resource. Can be triggered by system state dependency or
 * via lookup as runnable.
 * @author hb
 *
 */

public class ConfigurationResource extends Resource implements IDependencyComponent, Runnable {
	private boolean loaded;
	private String name;
	
	public ConfigurationResource(String name) {
		this.name = name;
	}

	public synchronized <T> T as(Class<T> clz) {
		if (IDependencyComponent.class.equals(clz)) {
			return clz.cast(this);
		}
		if (Runnable.class.equals(clz)) {
			return clz.cast(this);
		}
		return super.as(clz);
	}

	public void prepare() {
		apply();
	}

	public void run() {
		apply();
	}
	
	public synchronized void apply() {
		if (!this.loaded) {
			try {
				// simply look for a log4j.properties file.
				File f = IComponentsManager.INSTANCE.retrieve(this.name);
				if (!f.exists() || !f.isDirectory()) {
					throw new IllegalStateException("Folder "+f+" not found: "+this.name);
				}
				f = new File(f,"log4j.properties");
				if (!f.exists() || f.isDirectory()) {
					throw new IllegalStateException("Configuration file "+f+" not found: "+this.name);
				}
				PropertyConfigurator.configure(f.getCanonicalPath());
			} catch (Exception e) {
				throw new RuntimeException("Failed to load log4j configuration: "+this.name,e);
			}
			this.loaded = true;
		}
	}

	public synchronized void invalidate() throws ResourceBusyException {
		this.loaded = false;
	}
}
