/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.hubcr;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.components.IDependencyComponent;
import com.zfabrik.resources.ResourceBusyException;
import com.zfabrik.resources.provider.Resource;

public class ComponentRepositoryResource extends Resource implements IDependencyComponent {
	private String name;
	// the actual repo
	private ComponentRepositoryImpl repo;
	// svn destination
	
	public ComponentRepositoryResource(String name) {
		this.name = name;
	}

	@Override
	public synchronized <T> T as(Class<T> clz) {
		if (IDependencyComponent.class.equals(clz)) {
			return clz.cast(this);
		}
		return null;
	}
	
	@Override
	public synchronized void invalidate() throws ResourceBusyException {
		if (this.repo!=null) {
			try {
				this.repo.stop();
			} finally {
				this.repo = null;
			}
		}
	}

	@Override
	public synchronized void prepare() {
		_load();
	}

	private void _load() {
		if (this.repo==null) {
			this.repo = new ComponentRepositoryImpl(this.name, handle().as(IComponentDescriptor.class).getProperties());
			this.repo.start();
		}
	}

}
