/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.svnaccess.svnkit;

import java.io.File;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;


/**
 * Application editor to simply export.
 * 
 * Note, we keep track of properties, as they also provide the last commit date that we
 * use to set the file time stamps (as we want accurate file timestamps)
 */
public class ApplicationEditor implements ISVNEditor {
	private File folder;
	private File file;
	private Properties props = new Properties();
	private SVNDeltaProcessor dp = new SVNDeltaProcessor();
	private String md5;

	public ApplicationEditor(File folder) {
		this.folder = folder;
	}

	public void abortEdit() throws SVNException {
		logger.finest("abortEdit");
	}

	public void absentDir(String dir) throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("absentDir: "+dir);
		}
	}

	public void absentFile(String file) throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("absentFile: "+file);
		}
	}

	public void addDir(String path, String arg1, long arg2) throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("addDir: "+path);
		}
		new File(this.folder,path).mkdir();
	}

	public void addFile(String path, String copyFromPath, long copyFromRevision)
			throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("addFile: "+path+", "+copyFromPath+", "+copyFromRevision);
		}
		this.file = new File(this.folder,path);
		this.props.clear();
	}

	public void changeDirProperty(String name,SVNPropertyValue propVal) throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("changeDirProperty: "+name+"="+propVal);
		}
	}

	public void changeFileProperty(String path, String name, SVNPropertyValue value)
			throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("changeFileProperty: "+path+", "+name+"="+value);
		}
		this.props.setProperty(name, value.getString());
	}

	public void closeDir() throws SVNException {
		logger.finest("closeDir");
	}

	public SVNCommitInfo closeEdit() throws SVNException {
		logger.finest("closeEdit");
		return null;
	}

	public void closeFile(String path, String md5) throws SVNException {
		if ((md5!=null) && (!md5.equals(this.md5))) {
			throw new IllegalStateException("md5 mismatch on "+path);
		}
		String date = this.props.getProperty(SVNProperty.COMMITTED_DATE);
		if (date!=null) {
			this.file.setLastModified(SVNDate.parseDateAsMilliseconds(date));
		} else {
			logger.warning("No Timestamp found for file "+this.file);
		} 
		if (logger.isLoggable(Level.FINER)) {
			logger.finer("Downloaded file "+path+" ("+this.file.length()+" bytes)");
		}
		this.file = null;
	}

	public void deleteEntry(String path, long rev) throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("deleteEntry:"+path);
		}
		new File(this.folder,path).delete();
	}

	public void openDir(String path, long rev) throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("openDir:"+path+", "+rev);
		}
	}

	public void openFile(String path, long rev) throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("openFile:"+path+", "+rev);
		}
		this.file = new File(this.folder,path);
	}

	public void openRoot(long rev) throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("openRoot:"+rev);
		}
	}

	public void targetRevision(long rev) throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("targetRevision:"+rev);
		}
	}

	public void applyTextDelta(String path, String baseChecksum) throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("applyTextDelta:"+path+", "+baseChecksum);
		}
		this.dp.applyTextDelta((File) null,this.file, true);
	}
	

	public OutputStream textDeltaChunk(String path,  SVNDiffWindow diffWindow)
			throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("textDeltaChunk:"+path);
		}
		this.dp.textDeltaChunk(diffWindow);		
		return null;
	}

	public void textDeltaEnd(String path) throws SVNException {
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("textDeltaEnd:"+path);
		}
		this.md5 = this.dp.textDeltaEnd();
		if (logger.isLoggable(Level.FINEST)) {
			logger.finest("textDeltaEnd md5:"+this.md5);
			logger.finest("textDeltaEnd length:"+this.file.length());
		}
	}

	private final static Logger logger = Logger.getLogger(ApplicationEditor.class.getName());
}
