/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components;

import com.zfabrik.components.provider.IComponentsRepository;
import com.zfabrik.components.provider.IComponentsRepositoryContext;


/**
 * The components manager provides access to the system's current view onto all component repositories. 
 * <p>
 * It represents the root view onto all repositories and should be used by clients to find out about components in the system. 
 * 
 * @see IComponentsRepository
 * @author hb
 *
 */
public interface IComponentsManager extends IComponentsRepository {
	
	/**
	 * Static access to components manager
	 */
	static IComponentsManager INSTANCE = initializer.get();

	/**
	 * Initialization help
	 */
	public static class initializer {
		private static IComponentsManager get() {
			try {
				return (IComponentsManager) Class.forName("com.zfabrik.impl.components.ComponentsManager").newInstance();
			} catch (Exception e) {
				RuntimeException t = new IllegalStateException("failed to load components manager",e);
				t.printStackTrace();
				throw t;
			}
		}
	}

	
	/**
	 * Register a components repository. The priority parameter controls
	 * in what order repositories will be asked for components. The higher the 
	 * priority of a repository the closer to the start of the list it will be put. 
	 * @param prio
	 * @param repo
	 */
	IComponentsRepositoryContext registerRepository(int prio, IComponentsRepository repo);
	
	/**
	 * Unregister a component repository.
	 * 
	 * @param repo
	 */
	void unregisterRepository(IComponentsRepository repo);
	
	
}
