/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components;

/**
 * This interface can be implemented by components that participate in system target configuration by either participating in a state component
 * or by having a state component depend. See the system states documentation. 
 * <p>
 * If so, before use of a dependent component, the {@link #prepare()} method of all dependency components will be called.
 * <p>
 * Calling calling {@link #prepare()} on a component that supports this interface will always traverse through all dependency components and invoke {@link #prepare()}, if available.  
 * <p>
 * 
 * 
 * @author hb
 *
 */
public interface IDependencyComponent {
	
	/**
	 * Prepare for use. 
	 */
	void prepare();
	
}
