/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.provider;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.resources.provider.Resource;

/**
 * A component factory is reponsible for providing a managed resource ({@link Resource}) given a component name. It provides the link between
 * a component type declaration and its semantics.
 * <p>
 * The component factory for a component type is invoked when no resource for a component of the given name is currently managed by the resource management system. 
 * In that case the component factory is asked to provide an implementation of  ({@link Resource}). Typically the component factory will
 * inspect the component descriptor ({@link IComponentDescriptor}) of the named component.
 * <p>
 * Component factory is also a component type. Declaration of a component factory typically looks like this:
 * <pre>
 * com.zfabrik.component.type=com.zfabrik.componentFactory
 * componentFactory.type=&lt;type that is implemented by the factory&gt;
 * component.className=&lt;class that implements the component factory&gt;
 * </pre>
 * 
 * Properties supported for component factories:
 * 
 * <ul>
 * <li>{@link IComponentDescriptor#COMPONENT_CLZ}</li>
 * <li>{@link #TYPE}</li>
 * <li>{@link #IMPLEMENTED_TYPE}</li>
 * </ul>
 * 
 * The class specified by {@link IComponentDescriptor#COMPONENT_CLZ} in the component factory's properties can either implement
 * this interface or be an extension of {@link Resource} that has a single string arg constructor. In the latter case, the implementation resource of
 * the requested component will be an instance of this class constructed by invoking that constructore with the component's name. 
 * 
 * <p>
 * 
 * The class will be loaded by the private loader of the sibling Java component of the component factory component - as described in {@link IComponentDescriptor#COMPONENT_CLZ}.
 *   
 * @see IComponentDescriptor
 * @see Resource
 * 
 * @author hb
 *
 */
public interface IComponentFactory {
	String TYPE = "com.zfabrik.componentFactory";
	String IMPLEMENTED_TYPE = "componentFactory.type";
	
	Resource createComponentResource(String name);

}
