/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.provider.props;

/**
 * Evaluator interface. An implementation of this is used during evaluation of
 * all expressions for one component descriptor as needed. This does not need 
 * to be thread safe and it will not be used across component descriptors without receiving
 * intermediate init/destroy calls. 
 */
public interface Evaluator extends AutoCloseable {

	/**
	 * Initialize evalution session
	 */
	void init(EvaluationContext context);
	
	/**
	 * Evaluate an expression tagged for this processor. A result of <code>null</code> is legal during
	 * processing but will eventually be removed from the properties set.
	 */
	Object eval(String expression);

	/**
	 * default close session does nothing
	 */
	@Override
	default void close() {}
}