/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.provider.util;

/**
 * Exception indicating that the system is in offline mode and repository operations
 * are not available as far as remote access is requested.
 */
public class OfflineModeException extends IllegalStateException {
	private static final long serialVersionUID = 1L;

	public OfflineModeException() {
		super("System is running in offline mode");
	}

	@Override
	public String toString() {
		return "System is running in offline mode";
	}
}
