package com.zfabrik.home.console;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;

/**
 * Return value from log page retrieval
 */
public class LogExcerpt implements Serializable {
	private static final long serialVersionUID = 1L;
	private long firstLineLogIndex;
	private List<String> lines;
	
	
	@ConstructorProperties({"firstLineLogIndex", "lines"}) 
	public LogExcerpt(long firstLineLogIndex, List<String> lines) {
		super();
		this.firstLineLogIndex = firstLineLogIndex;
		this.lines = lines;
	}
	/**
	 * Overall no. of first line in log. This may be different than the requested start line
	 * if the buffer does not have the latter anymore.
	 */
	public long getFirstLineLogIndex() {
		return firstLineLogIndex;
	}
	/**
	 * Lines from the log
	 */
	public List<String> getLines() {
		return lines;
	}
}