/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.components.local;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import com.zfabrik.components.java.IJavaComponent;
import com.zfabrik.components.provider.util.AbstractComponentDescriptor;
import com.zfabrik.components.provider.util.FSComponentRepositoryDB;

public class ComponentImpl extends AbstractComponentDescriptor {
	private static final long serialVersionUID = 1L;
	private static final String PROPERTIES_SUFFIX = ".properties";
	

	public ComponentImpl(Properties props,String name) {
		super.setName(name);
		super.setProperties(props);
	}


	public static void scan(File f, final Map<String, ComponentImpl> components, final Set<String> modules) {
		final Set<String> cs = new HashSet<String>();
		f.listFiles(new FileFilter() {
			public boolean accept(File pathname) {
				if (pathname.getName().endsWith(PROPERTIES_SUFFIX)) {
					String n = pathname.getName();
					n = n.substring(0,n.length()-PROPERTIES_SUFFIX.length());
					cs.add(n);
				} else if ((pathname.isDirectory()) && (!pathname.getName().startsWith("."))) {
					cs.add(pathname.getName());
				}
				return false;
			}
		});
		Properties p;
		File pf;
		String n;
		for (String cn : cs) {
			n = f.getName()+"/"+cn;
			pf = new File(f,cn+PROPERTIES_SUFFIX);
			if (pf.exists()) {
				// defined by props
				p = readComponentProps(pf,n);
				components.put(n, new ComponentImpl(p,n));
			} else {
				pf = new File(f,cn+"/z.properties");
				p = readComponentProps(pf,n);
				components.put(n, new ComponentImpl(p,n));
			}
			modules.add(FSComponentRepositoryDB.moduleOf(n));
		}
	}

	private static Properties readComponentProps(File pf, String n) {
		InputStream fin;
		Properties p;
		try {
			fin = new FileInputStream(pf);
			try {
				p = new Properties();
				p.load(fin);
			} finally {
				fin.close();
			}
		} catch (IOException ioe) {
			throw new IllegalStateException("Error when trying to read component properties: "+n,ioe);
		}
		// no build for the FS repos!
		p.setProperty(IJavaComponent.NOBUILD, "true");
		return p;
	}

	public long getRevision() {
		return 0;
	}
}
