/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.util.logging;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;


public class LoggerFacade extends Logger {
	private Logger logger;
	private Handler logHandler;

	public LoggerFacade(String name, Logger logger, Handler logHandler) {
		super(name,null);
		this.logger = logger;
		this.logHandler = logHandler;
	}
	
	public void log(LogRecord record) {
		if (this.logHandler!=null) {
			if (this.logHandler.isLoggable(record)) {
				this.logHandler.publish(record);
				this.logHandler.flush();
			}
		}
		this.logger.log(record);
	}
	
	public void close() {
		if (this.logHandler!=null) {
			this.logHandler.close();
		}
	}
	
}
