/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.components.java.jdt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;

import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;

/**
 * A simple, file based compilation unit implementation
 * @author hb
 */
public class FileCompilationUnit implements ICompilationUnit {
	private File file;
	private String encoding;
	private char[] contents,mainTypeName,fileName;
	
	public FileCompilationUnit(File file, String encoding) {
		this.file =file;
		this.encoding = encoding;
		String fn = this.file.getName();
		this.fileName = fn.toCharArray();
		int p = fn.lastIndexOf('.');
		fn = (p>=0? fn.substring(0,p):fn);
		this.mainTypeName = fn.toCharArray();
	}

	public char[] getContents() {
		if (this.contents == null) {
			try {
				this.contents = new char[(int)this.file.length()];
				if (this.contents.length>0) {
					Reader fr = new InputStreamReader(new FileInputStream(this.file),this.encoding);
					try {
						int l = fr.read(this.contents);
						// cut it (file length can be longer that the actual number of chars
						this.contents = Arrays.copyOf(this.contents, l);
					} finally {fr.close();}
				}
			} catch (Exception e) {
				throw new RuntimeException("Failed to read file "+this.file, e);
			}
		}
		return this.contents;
	}

	public char[] getMainTypeName() {
		return this.mainTypeName;
	}

	public char[][] getPackageName() {
		return null;
	}

	public char[] getFileName() {
		return this.fileName;
	}
	
	@Override
	public boolean ignoreOptionalProblems() {
		return true;
	}
}
