/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.components.processing;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.MapContext;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.components.IComponentsManager;
import com.zfabrik.components.provider.props.EvaluationContext;
import com.zfabrik.components.provider.props.EvaluationException;
import com.zfabrik.components.provider.props.Evaluator;

/**
 * {@link Evaluator} for Jexl3 expressions. 
 * See {@link Jexl3ComponentDescriptorProcessor}.
 */
public class Jexl3ComponentDescriptorEvaluator implements Evaluator {
	private final static Logger LOG = Logger.getLogger(Jexl3ComponentDescriptorEvaluator.class.getName());

	private JexlContext jexlContext;
	private JexlEngine  jexlEngine;
	
	@Override
	public void init(EvaluationContext context) {
		JexlBuilder bu = new JexlBuilder();
		// todo: use better scope?
		bu.loader(IComponentDescriptor.class.getClassLoader());

		// create the engine
		this.jexlEngine = bu.create();
		// provide some context
		
		// inner resolution loop
		JexlContext thus = new JexlContext() {
			@Override
			public void set(String name, Object value) { throw new UnsupportedOperationException();}
			
			@Override
			public boolean has(String name) {
				return context.has(name);
			}
			
			@Override
			public Object get(String name) {
				return context.get(name);
			}
		};
		
		// more context
		Map<String,Object> mm = new HashMap<>();
		mm.put("system", System.getProperties());
		mm.put("env", System.getenv());
		mm.put("this", thus);
		mm.put("components", IComponentsManager.INSTANCE);
		
		// this is it
		this.jexlContext = new MapContext(mm);
	}
	
	@Override
	public Object eval(String expression) {
		try {
			return this.jexlEngine.createExpression(expression).evaluate(this.jexlContext);
		} catch (JexlException e1) {
			// unwrap evaluation exceptions
			if (e1.getCause() instanceof EvaluationException) {
				throw (EvaluationException) e1.getCause();
			}
			throw e1;
		}
	}
}
