/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.gitcr;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.components.IDependencyComponent;
import com.zfabrik.resources.ResourceBusyException;
import com.zfabrik.resources.provider.Resource;

/**
 * See {@link GitComponentRepositoryImpl}
 * @author udoo
 *
 */
public class GitComponentRepositoryResource extends Resource implements IDependencyComponent {
	
	private String name;
	// the actual repo
	private GitComponentRepositoryImpl repo;
	// svn destination
	
	public GitComponentRepositoryResource(String name) {
		this.name = name;
	}

	public synchronized <T> T as(Class<T> clz) {
		if (GitComponentRepositoryImpl.has(clz)) {
			_load();
			return this.repo.as(clz);
		}
		if (IDependencyComponent.class.equals(clz)) {
			return clz.cast(this);
		}
		return null;
	}
	
	public synchronized void invalidate() throws ResourceBusyException {
		if (this.repo!=null) {
			try {
				this.repo.stop();
			} finally {
				this.repo = null;
			}
		}
	}

	public synchronized void prepare() {
		_load();
	}

	private void _load() {
		if (this.repo==null) {
			this.repo = new GitComponentRepositoryImpl(this.name, handle().as(IComponentDescriptor.class).getProperties());
			this.repo.start();
		}
	}


}
