/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.gitcr.helper;

import java.util.Stack;
import java.util.logging.Logger;

import org.eclipse.jgit.lib.ProgressMonitor;

/**
 * A simple progress monitor for Git operations
 */
public class ProgressMonitorImpl implements ProgressMonitor {
	private Logger log; 
	private int totalWork;
	private int workDone;
	private long lastReport=0;
	private Stack<String> task = new Stack<>();

	public ProgressMonitorImpl(Logger log) {
		super();
		this.log = log;
	}

	@Override
	public void start(int totalTasks) {}

	@Override
	public void beginTask(String title, int totalWork) {
		task.push(title);
		this.totalWork = totalWork;
		this.workDone = 0;
		if (this.totalWork>0) {
			log.info(title);
		}
	}

	@Override
	public void update(int completed) {
		this.workDone+=completed;
		status(false);
	}

	@Override
	public void endTask() {
		status(true);
		if (this.totalWork>0) {
			log.info(this.task.pop()+" - done.");
		}
	}

	@Override
	public boolean isCancelled() {
		return false;
	}
	
	private void status(boolean force) {
		if (force || System.currentTimeMillis()-lastReport>30000) {
			if (this.totalWork>0) {
				log.info(this.workDone+"/"+this.totalWork);
			}
			this.lastReport = System.currentTimeMillis();
		}
	}

}
