package com.zfabrik.util.function;

import java.util.concurrent.Callable;

/**
 * A supplier of results that optionally throws an exception. 
 * 
 * Together with Java's type inference this interface is very useful
 * for many cases, where using {@link Callable} would be to unspecific and
 * using {@link Supplier} would require extra handling of checked exceptions
 */
@FunctionalInterface
public interface ThrowingSupplier<T, E extends Exception> {

    /**
     * Gets a result.
     *
     * @return a result
     */
    T get() throws E;
}
