/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.provider.resolver;

import java.util.Collection;

import com.zfabrik.components.IComponentsLookup;
import com.zfabrik.components.IComponentsManager;
import com.zfabrik.resources.IResourceHandle;
import com.zfabrik.resources.IResourceObserver;
import com.zfabrik.resources.ResourceBusyException;
import com.zfabrik.resources.provider.IResourceProvider;
import com.zfabrik.resources.provider.Resource;
import com.zfabrik.util.expression.X;

/**
 * resolution cache pattern
 * @author hb
 */
public class ProviderResolution extends Resource {

	private String name;
	private IResourceObserver ph;
	private X x_providers;

	public ProviderResolution(String name) {
		this.name = name;
		this.x_providers=X.var(IResourceProvider.PROP_NAMESPACE).eq(X.val(name));
	}

	@Override
	public synchronized <T> T as(Class<T> clz) {
		if (IResourceProvider.class.equals(clz)) {
			IResourceHandle rh = (this.ph != null ? this.ph.getHandle() : null);
			if (rh == null) {
				try {
					Collection<String> comps = IComponentsManager.INSTANCE.findComponents(this.x_providers);
					if (comps.size() == 0) {
						return null;
					}
					if (comps.size() > 1) {
						throw new IllegalStateException("Found more than one resource provider implementation for namespace (" + name + ")");
					}
					rh = IComponentsLookup.INSTANCE.lookup(comps.iterator().next(), IResourceHandle.class);
					if (rh.as(IResourceProvider.class) != null) {
						// it is a resource provider.
						this.ph = rh.as(IResourceObserver.class);
						handle().addDependency(rh);
						handle().adjust(0, Long.MAX_VALUE, IResourceHandle.STRONG);
					}
				} catch (Exception e) {
					throw new IllegalStateException("Failed to search resource provider implementation for namespace (" + name + ")", e);
				}
			}
			return clz.cast(rh.as(IResourceProvider.class));
		}
		return null;
	}

	public synchronized void invalidate() throws ResourceBusyException {
		handle().adjust(0, Long.MAX_VALUE, IResourceHandle.WEAK);
	}

}
