/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.fscr;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.zfabrik.components.provider.util.AbstractExtComponentRepository;
import com.zfabrik.util.sync.ISynchronization;
import com.zfabrik.util.sync.ISynchronizer;

/**
 * Synchronizer for all repos based on {@link AbstractExtComponentRepository}.
 *
 * TODO: Move into better suited package
 *
 * @author hb
 *
 */
public class SynchronizerImpl implements ISynchronizer {

	@Override
	public void preInvalidation(ISynchronization sync) {
		for (Map.Entry<String, AbstractExtComponentRepository<?,?>> e : AbstractExtComponentRepository.ALL.entrySet()) {
			try {
				e.getValue().preInvalidation(sync);
			} catch (Exception ex) {
				logger.log(Level.WARNING,"Error during preInvalidation of repository ("+e.getKey()+")",ex);
			}
		}
	}

	@Override
	public void complete(ISynchronization sync) {
		for (Map.Entry<String, AbstractExtComponentRepository<?,?>> e : AbstractExtComponentRepository.ALL.entrySet()) {
			try {
				e.getValue().complete(sync);
			} catch (Exception ex) {
				logger.log(Level.WARNING,"Error during complete of repository ("+e.getKey()+")",ex);
			}
		}
	}


	private final static Logger logger = Logger.getLogger(SynchronizerImpl.class.getName());
}
