/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.provider.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

/**
 * A very basic abstraction of what a component storage does (whether local or remote) as
 * far as a component repository is concerned.
 * <p>
 * Implementations of this interface serve to hold components and component resources
 * organized in a folder style structure where the root level contains <em>modules</em>
 * (or <em>projects</em>) and the second level contains component folders containing a 
 * properties file resource <code>z.properties</code> or direct component definitions 
 * in the form of <code>.properties</code> file resources.
 * <p>
 * File resources are provided via instances of {@link AbstractFile}. 
 * <p>
 * All names for files are absolute. Paths do not start with "/" but paths are separated by "/".
 * The root folder is hence named "", rather than "/"
 *  
 * @author hb
 *
 */
public interface IAbstractFileSystem {

	/**
	 * Returns the root folder
	 * @return Root folder
	 */
	File getRoot();
	
	/**
	 * Check whether a file exists.
	 * @param name
	 * @return <code>true</code> if the named file exists, <code>false</code> otherwise.
	 */
	boolean exists(String name) throws IOException;
	
	/**
	 * Retrieve the named resource as InputStream
	 */
	InputStream getInputStream(String name) throws IOException;

	/**
	 * list files under another file, i.e. a folder. The first result element is 
	 * the named file as specified by the signature. 
	 */
	public List<AbstractFile> list(String name, int depth) throws IOException;

	/**
	 * Iterate over files under another file, i.e. a folder. The first result element is 
	 * the named file as specified by the signature.
	 * When working over large sets of files this method should realize the advantage that 
	 * it does not require to read everything in advance, saving memory and time.  
	 */
	public Iterator<AbstractFile> iterate(String name, int depth) throws IOException;


}
