/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.provider.fs;

import com.zfabrik.components.provider.util.FSCRDBComponent;

/**
 * A root bound FSCRDBComponent. We only add some extra
 * information to bind the root the component was found in.
 */
public class RootBoundFSCRComponent extends FSCRDBComponent {
	private static final long serialVersionUID = 1L;
	private String root;

	public RootBoundFSCRComponent(RootBoundFSCRComponent c) {
		super(c);
	}

	public RootBoundFSCRComponent(String name) {
		super(name);
	}

	public void setRoot(String root) {
		this.root = root;
	}

	public String getRoot() {
		return root;
	}
}
