/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.java.build;

import java.io.File;

import com.zfabrik.components.java.IJavaComponent;

/**
 * Context for a specific compilation. Used by invocations of {@link ICompiler#}
 */
public interface ICompilationContext {

	/**
	 * Gets the name of the component to be compiled
	 */
	String getComponentName();
	
	/**
	 * Get the runtime resources folder for the Java component currently 
	 * under construction. This is the place to put any build results and 
	 * modifications. Do NOT modify the original component resources.
	 */
	File getRuntimeResources();
	
	/**
	 * Gets the folder containing the source files
	 */
	File[] getSourceFolders(); 
	
	/**
	 * Gets the folder to put compile results and that may already contain compilation results from other compilers
	 */
	File getOutputFolder(); 

	/**
	 * Gets a class loader as class path abstraction for this compilation
	 */
	ClassLoader getClassPath();
	
	/**
	 * {@link IJavaComponent.Part} of the component to compile
	 */
	IJavaComponent.Part getPart();
}
