/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.home.console;

public interface HomeMXBean {
	String OBJECTNAME = "zfabrik:type=launchers.HomeLauncher";

	/**
	 * Synchronous verfication
	 */
	void verify() throws Exception;
	/**
	 * asynchronous verfication
	 */
	void averify() throws Exception;
	/**
	 * Synchronous synchronization
	 */
	void synchronize() throws Exception;
	/**
	 * Asynchronous synchronization
	 */
	void asynchronize() throws Exception;
	/**
	 * Clear counters, log buffer.
	 */
	void clear();
	
	/**
	 * Last sync started
	 */
	Long getLastSynchronizationStartTime();

	/**
	 * Last sync completed
	 */
	Long getLastSynchronizationCompletionTime();

	/**
	 * Set size (in number of lines) and expiration of log buffer. If <code>extend</code> is set to 
	 * true the specified values will only be applied espectively, if they exceed the currently
	 * set values. 
	 */
	void configureLogBuffer(int size, long expiration, boolean extend);
	
	/**
	 * Get info on the current state of the log buffer
	 */
	LogBufferInfo getLogBufferInfo();
	
	/**
	 * Fetch a page of log lines from the buffer. The index is in absolute lines handled since start of the 
	 * log buffer (which is close to system start). 
	 */
	LogExcerpt getLogBufferLines(long start, int count);
	
	
}
