package com.zfabrik.launch.util;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;

public class LogStreamer {
	// from max 1000 lines buffer with expiration in 10sec, pull 100 every
	// 250 ms.
	private int bufferSize = 1000;
	private int expiresIn = 10000;
	private int chunkSize = 100;
	private int delay = 250;
	private long base;

	private MBeanServerConnection mbs;
	private ObjectName on;
	
	
	public LogStreamer(MBeanServerConnection mbs, int before) throws Exception {
		this.on = ObjectName.getInstance("zfabrik:type=launchers.HomeLauncher");
		this.mbs = mbs;
		// get the log baseline
		CompositeData logBufferInfo = (CompositeData) mbs.getAttribute(on, "LogBufferInfo");
		
		Long linesHandled = (Long) logBufferInfo.get("linesHandled");
		Integer currentSize = (Integer) logBufferInfo.get("size");
		this.base = Math.max(0, linesHandled - Math.min(Math.min(bufferSize, currentSize), before));
	}
	
	public void logLatest() throws Exception {
		// get the last N lines
		CompositeData logLines = (CompositeData) mbs.invoke(
			on, 
			"getLogBufferLines", 
			new Object[] { base, chunkSize },
			new String[] { "long", "int" }
		);
		// extend expiration
		configureLogBuffer();

		long actualBase = (Long) logLines.get("firstLineLogIndex");
		if (actualBase > base) {
			System.out.println("-- MISSED " + (actualBase - base) + " lines! --");
		}
		String[] lines = (String[]) logLines.get("lines");
		for (String line : lines) {
			// log lines already have a newline.
			System.out.print(line);
		}
		System.out.flush();
		// next base
		base = actualBase + lines.length;
	}
	
	public void logWhile(AtomicBoolean busy) throws Exception {
		boolean stop = false;
		do {
			stop = !busy.get();
			logLatest();
			Thread.sleep(delay);
		} while (!stop);
	}
	
	private void configureLogBuffer() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, RemoteException {
		// set log buffer to N lines with an expiration of 10secs
		mbs.invoke(
			on, 
			"configureLogBuffer", 
			new Object[] { bufferSize, System.currentTimeMillis() + expiresIn, true },
			new String[] { "int", "long", "boolean" }
		);
	}

}
