/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.resources;

/**
 * Resource metadata.
 * 
 * @see IResourceHandle#getResourceInfo()
 * @author hb
 */
public interface IResourceInfo {

	/**
	 * Name of resource
	 */
	String getName();
	/**
	 * Time to live. See {@link IResourceHandle#adjust(long, long, short)}
	 */
	long   getTimeToLive();
	/**
	 * Expiration time. See {@link IResourceHandle#adjust(long, long, short)}
	 */
	long   getExpiration();
	/**
	 * Reference mode, See {@link IResourceHandle#WEAK}, {@link IResourceHandle#SOFT}, and {@link IResourceHandle#STRONG}.
	 * @return
	 */
	short  getRefMode();
	
	
}
